//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FileFindForm1.h"
#include "Lookdir.cpp"

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TFileFindForm *FileFindForm;
//---------------------------------------------------------------------------
__fastcall TFileFindForm::TFileFindForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFileFindForm::CancelClick(TObject *Sender)
{
    cancelpushed = true;
    Find->Caption = "Find";
	FileFindForm->Hide();

}
//---------------------------------------------------------------------------
void __fastcall TFileFindForm::FindClick(TObject *Sender)
{
	if(Find->Caption == "Find")
    {
    	cancelpushed = false;

		targetstring = (char *) malloc(strlen(TargetEdit->Text.c_str()) + 1);
        strcpy(targetstring, TargetEdit->Text.c_str());

		if(FindHex->Checked == true && TargetEdit->Text != "")
	    {
    		int i, j = 0;
        	char buf[3];

   			if(strlen(targetstring) % 2)
			{
				Application->MessageBox("Error: Uneven number of hex characters", "Error", MB_OK + MB_ICONERROR);
				free(targetstring);
				return;
			}

			for(i = 0;i < (int) strlen(targetstring);i++)
            {
				if(!isxdigit(targetstring[i]))
				{
					Application->MessageBox("Error: Invalid hex character", "Error", MB_OK + MB_ICONERROR);
           			free(targetstring);
					return;
				}
			}

   			ResultsList->Clear();
           	Find->Caption = "Stop";

	    	size = strlen(TargetEdit->Text.c_str()) / 2;
    	    target = (unsigned char *) malloc(size);

			for(i = 0;i < size * 2;i += 2)
			{
				buf[0] = targetstring[i];
				buf[1] = targetstring[i+1];
				target[j++] = hstr_i(buf);
			}

   			if(Recurse->Checked == true)
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 1, 1, target, size);
		    else
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 0, 1, target, size);
	    }
		else if(TargetEdit->Text != "")
	    {
			int i;

   			ResultsList->Clear();
           	Find->Caption = "Stop";

			size = strlen(TargetEdit->Text.c_str());
	        target = (unsigned char *) malloc(size);
    	    for(i = 0;i < size;i++)
        		target[i] = targetstring[i];

	   		if(Recurse->Checked == true)
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 1, 1, target, size);
	    	else
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 0, 1, target, size);
	    }
		else
	    {
   			ResultsList->Clear();
           	Find->Caption = "Stop";

			if(Recurse->Checked == true)
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 1, 0, target, size);
		    else
				look(DirTree->Directory.c_str(), FileMask->Text.c_str(), 0, 0, target, size);
	    }
        Find->Caption = "Find";
    }
    else
    {
   		cancelpushed = true;
        Find->Caption = "Find";
    }
	free(targetstring);
    free(target);
}

//---------------------------------------------------------------------------
void __fastcall TFileFindForm::DirTreeChange(TObject *Sender)
{
try {
	DirTree->Drive = DriveComboBox->Drive;
} catch(...){};
}
//---------------------------------------------------------------------------

